<?php

/**
 * Contao Open Source CMS
 * 
 * Copyright (c) 2005-2015 Leo Feyer
 * 
 * Core translations are managed using Transifex. To create a new translation
 * or to help to maintain an existing one, please register at transifex.com.
 * 
 * @link http://help.transifex.com/intro/translating.html
 * @link https://www.transifex.com/projects/p/contao/language/en/
 * 
 * @license LGPL-3.0+
 */

// system/modules/core/languages/en/tl_module.xlf
$GLOBALS['TL_LANG']['tl_module']['name'][0] = 'Title';
$GLOBALS['TL_LANG']['tl_module']['name'][1] = 'Please enter the module title.';
$GLOBALS['TL_LANG']['tl_module']['headline'][0] = 'Headline';
$GLOBALS['TL_LANG']['tl_module']['headline'][1] = 'Here you can add a headline to the module.';
$GLOBALS['TL_LANG']['tl_module']['type'][0] = 'Module type';
$GLOBALS['TL_LANG']['tl_module']['type'][1] = 'Please choose the type of module.';
$GLOBALS['TL_LANG']['tl_module']['levelOffset'][0] = 'Start level';
$GLOBALS['TL_LANG']['tl_module']['levelOffset'][1] = 'Enter a value greater than 0 to show only submenu items.';
$GLOBALS['TL_LANG']['tl_module']['showLevel'][0] = 'Stop level';
$GLOBALS['TL_LANG']['tl_module']['showLevel'][1] = 'Enter a value greater than 0 to limit the nesting level of the menu.';
$GLOBALS['TL_LANG']['tl_module']['hardLimit'][0] = 'Hard limit';
$GLOBALS['TL_LANG']['tl_module']['hardLimit'][1] = 'Never show any menu items beyond the stop level.';
$GLOBALS['TL_LANG']['tl_module']['showProtected'][0] = 'Show protected items';
$GLOBALS['TL_LANG']['tl_module']['showProtected'][1] = 'Show items that are usually only visible to authenticated users.';
$GLOBALS['TL_LANG']['tl_module']['defineRoot'][0] = 'Set a reference page';
$GLOBALS['TL_LANG']['tl_module']['defineRoot'][1] = 'Define a custom source or target page for the module.';
$GLOBALS['TL_LANG']['tl_module']['rootPage'][0] = 'Reference page';
$GLOBALS['TL_LANG']['tl_module']['rootPage'][1] = 'Please choose the reference page from the site structure.';
$GLOBALS['TL_LANG']['tl_module']['navigationTpl'][0] = 'Navigation template';
$GLOBALS['TL_LANG']['tl_module']['navigationTpl'][1] = 'Here you can select the navigation template.';
$GLOBALS['TL_LANG']['tl_module']['customTpl'][0] = 'Custom module template';
$GLOBALS['TL_LANG']['tl_module']['customTpl'][1] = 'Here you can overwrite the default module template.';
$GLOBALS['TL_LANG']['tl_module']['pages'][0] = 'Pages';
$GLOBALS['TL_LANG']['tl_module']['pages'][1] = 'Please choose one or more pages from the site structure.';
$GLOBALS['TL_LANG']['tl_module']['showHidden'][0] = 'Show hidden items';
$GLOBALS['TL_LANG']['tl_module']['showHidden'][1] = 'Show items that are usually hidden in the navigation menu.';
$GLOBALS['TL_LANG']['tl_module']['customLabel'][0] = 'Custom label';
$GLOBALS['TL_LANG']['tl_module']['customLabel'][1] = 'Here you can enter a custom label for the drop-down menu.';
$GLOBALS['TL_LANG']['tl_module']['autologin'][0] = 'Allow auto login';
$GLOBALS['TL_LANG']['tl_module']['autologin'][1] = 'Allow members to log into the front end automatically.';
$GLOBALS['TL_LANG']['tl_module']['jumpTo'][0] = 'Redirect page';
$GLOBALS['TL_LANG']['tl_module']['jumpTo'][1] = 'Please choose the page to which visitors will be redirected when clicking a link or submitting a form.';
$GLOBALS['TL_LANG']['tl_module']['redirectBack'][0] = 'Redirect to last page visited';
$GLOBALS['TL_LANG']['tl_module']['redirectBack'][1] = 'Redirect the user back to the last page visited instead of the redirect page.';
$GLOBALS['TL_LANG']['tl_module']['cols'][0] = 'Number of columns';
$GLOBALS['TL_LANG']['tl_module']['cols'][1] = 'Please choose the number of columns of the form.';
$GLOBALS['TL_LANG']['tl_module']['1cl'][0] = 'One column';
$GLOBALS['TL_LANG']['tl_module']['1cl'][1] = 'Show the label above the input field.';
$GLOBALS['TL_LANG']['tl_module']['2cl'][0] = 'Two columns';
$GLOBALS['TL_LANG']['tl_module']['2cl'][1] = 'Show the label on the left side of the input field.';
$GLOBALS['TL_LANG']['tl_module']['editable'][0] = 'Editable fields';
$GLOBALS['TL_LANG']['tl_module']['editable'][1] = 'Show these fields in the front end form.';
$GLOBALS['TL_LANG']['tl_module']['memberTpl'][0] = 'Form template';
$GLOBALS['TL_LANG']['tl_module']['memberTpl'][1] = 'Here you can select the form template.';
$GLOBALS['TL_LANG']['tl_module']['tableless'][0] = 'Tableless layout';
$GLOBALS['TL_LANG']['tl_module']['tableless'][1] = 'Render the form without HTML tables.';
$GLOBALS['TL_LANG']['tl_module']['form'][0] = 'Form';
$GLOBALS['TL_LANG']['tl_module']['form'][1] = 'Please select a form.';
$GLOBALS['TL_LANG']['tl_module']['queryType'][0] = 'Default query type';
$GLOBALS['TL_LANG']['tl_module']['queryType'][1] = 'Please select the default query type.';
$GLOBALS['TL_LANG']['tl_module']['and'][0] = 'Find all words';
$GLOBALS['TL_LANG']['tl_module']['and'][1] = 'Returns only pages that contain all keywords.';
$GLOBALS['TL_LANG']['tl_module']['or'][0] = 'Find any word';
$GLOBALS['TL_LANG']['tl_module']['or'][1] = 'Returns all pages that contain any of the keywords.';
$GLOBALS['TL_LANG']['tl_module']['fuzzy'][0] = 'Fuzzy search';
$GLOBALS['TL_LANG']['tl_module']['fuzzy'][1] = 'Will find "Contao" if you search for "con" (equal to a wildcard search).';
$GLOBALS['TL_LANG']['tl_module']['simple'][0] = 'Simple form';
$GLOBALS['TL_LANG']['tl_module']['simple'][1] = 'Contains a single input field only.';
$GLOBALS['TL_LANG']['tl_module']['advanced'][0] = 'Advanced form';
$GLOBALS['TL_LANG']['tl_module']['advanced'][1] = 'Contains an input field and a radio button menu to choose the query type.';
$GLOBALS['TL_LANG']['tl_module']['contextLength'][0] = 'Context range';
$GLOBALS['TL_LANG']['tl_module']['contextLength'][1] = 'The number of characters on the left and right side of each keyword that are used as context.';
$GLOBALS['TL_LANG']['tl_module']['totalLength'][0] = 'Maximum context length';
$GLOBALS['TL_LANG']['tl_module']['totalLength'][1] = 'Here you can limit the overall context length per result.';
$GLOBALS['TL_LANG']['tl_module']['perPage'][0] = 'Items per page';
$GLOBALS['TL_LANG']['tl_module']['perPage'][1] = 'The number of items per page. Set to 0 to disable pagination.';
$GLOBALS['TL_LANG']['tl_module']['searchType'][0] = 'Search form layout';
$GLOBALS['TL_LANG']['tl_module']['searchType'][1] = 'Here you can select the search form layout.';
$GLOBALS['TL_LANG']['tl_module']['searchTpl'][0] = 'Search results template';
$GLOBALS['TL_LANG']['tl_module']['searchTpl'][1] = 'Here you can select the search results template.';
$GLOBALS['TL_LANG']['tl_module']['inColumn'][0] = 'Column';
$GLOBALS['TL_LANG']['tl_module']['inColumn'][1] = 'Please choose the column whose articles you want to list.';
$GLOBALS['TL_LANG']['tl_module']['skipFirst'][0] = 'Skip items';
$GLOBALS['TL_LANG']['tl_module']['skipFirst'][1] = 'Here you can define how many items will be skipped.';
$GLOBALS['TL_LANG']['tl_module']['loadFirst'][0] = 'Load the first item';
$GLOBALS['TL_LANG']['tl_module']['loadFirst'][1] = 'Automatically redirect to the first item if none is selected.';
$GLOBALS['TL_LANG']['tl_module']['size'][0] = 'Width and height';
$GLOBALS['TL_LANG']['tl_module']['size'][1] = 'Please enter the width and height in pixel.';
$GLOBALS['TL_LANG']['tl_module']['transparent'][0] = 'Transparent movie';
$GLOBALS['TL_LANG']['tl_module']['transparent'][1] = 'Make the Flash movie transparent (wmode = transparent).';
$GLOBALS['TL_LANG']['tl_module']['flashvars'][0] = 'FlashVars';
$GLOBALS['TL_LANG']['tl_module']['flashvars'][1] = 'Pass variables to the Flash movie (<em>var1=value1&amp;var2=value2</em>).';
$GLOBALS['TL_LANG']['tl_module']['version'][0] = 'Flash player version';
$GLOBALS['TL_LANG']['tl_module']['version'][1] = 'Please enter the required Flash player version (e.g. 6.0.12).';
$GLOBALS['TL_LANG']['tl_module']['altContent'][0] = 'Alternate content';
$GLOBALS['TL_LANG']['tl_module']['altContent'][1] = 'The alternate content will be shown if the movie cannot be loaded. HTML tags are allowed.';
$GLOBALS['TL_LANG']['tl_module']['source'][0] = 'Source';
$GLOBALS['TL_LANG']['tl_module']['source'][1] = 'Whether to use a file on the server or point to an external URL.';
$GLOBALS['TL_LANG']['tl_module']['singleSRC'][0] = 'Source file';
$GLOBALS['TL_LANG']['tl_module']['singleSRC'][1] = 'Please select a file from the files directory.';
$GLOBALS['TL_LANG']['tl_module']['url'][0] = 'URL';
$GLOBALS['TL_LANG']['tl_module']['url'][1] = 'Please enter the URL (http://…) of the Flash movie.';
$GLOBALS['TL_LANG']['tl_module']['interactive'][0] = 'Make interactive';
$GLOBALS['TL_LANG']['tl_module']['interactive'][1] = 'Make the Flash movie interact with the browser (requires JavaScript).';
$GLOBALS['TL_LANG']['tl_module']['flashID'][0] = 'Flash movie ID';
$GLOBALS['TL_LANG']['tl_module']['flashID'][1] = 'Please enter a unique Flash movie ID.';
$GLOBALS['TL_LANG']['tl_module']['flashJS'][0] = 'JavaScript _DoFSCommand(command, args) {';
$GLOBALS['TL_LANG']['tl_module']['flashJS'][1] = 'Please enter the JavaScript code.';
$GLOBALS['TL_LANG']['tl_module']['fullsize'][0] = 'Full-size view/new window';
$GLOBALS['TL_LANG']['tl_module']['fullsize'][1] = 'Open the full-size image in a lightbox or the link in a new browser window.';
$GLOBALS['TL_LANG']['tl_module']['imgSize'][0] = 'Image width and height';
$GLOBALS['TL_LANG']['tl_module']['imgSize'][1] = 'Here you can set the image dimensions and the resize mode.';
$GLOBALS['TL_LANG']['tl_module']['useCaption'][0] = 'Show caption';
$GLOBALS['TL_LANG']['tl_module']['useCaption'][1] = 'Display the image name or caption below the image.';
$GLOBALS['TL_LANG']['tl_module']['multiSRC'][0] = 'Source files';
$GLOBALS['TL_LANG']['tl_module']['multiSRC'][1] = 'Please select one or more files from the files directory.';
$GLOBALS['TL_LANG']['tl_module']['orderSRC'][0] = 'Sort order';
$GLOBALS['TL_LANG']['tl_module']['orderSRC'][1] = 'The sort order of the items.';
$GLOBALS['TL_LANG']['tl_module']['html'][0] = 'HTML code';
$GLOBALS['TL_LANG']['tl_module']['html'][1] = 'You can modify the list of allowed HTML tags in the back end settings.';
$GLOBALS['TL_LANG']['tl_module']['rss_cache'][0] = 'Cache timeout';
$GLOBALS['TL_LANG']['tl_module']['rss_cache'][1] = 'Here you can define how long the RSS feed is being cached.';
$GLOBALS['TL_LANG']['tl_module']['rss_feed'][0] = 'Feed URLs';
$GLOBALS['TL_LANG']['tl_module']['rss_feed'][1] = 'Please enter the URL of one or more RSS feeds.';
$GLOBALS['TL_LANG']['tl_module']['rss_template'][0] = 'Feed template';
$GLOBALS['TL_LANG']['tl_module']['rss_template'][1] = 'Here you can select the feed template.';
$GLOBALS['TL_LANG']['tl_module']['numberOfItems'][0] = 'Number of items';
$GLOBALS['TL_LANG']['tl_module']['numberOfItems'][1] = 'Here you can limit the number of items. Set to 0 to show all.';
$GLOBALS['TL_LANG']['tl_module']['protected'][0] = 'Protect module';
$GLOBALS['TL_LANG']['tl_module']['protected'][1] = 'Show the module to certain member groups only.';
$GLOBALS['TL_LANG']['tl_module']['groups'][0] = 'Allowed member groups';
$GLOBALS['TL_LANG']['tl_module']['groups'][1] = 'These groups will be able to see the module.';
$GLOBALS['TL_LANG']['tl_module']['guests'][0] = 'Show to guests only';
$GLOBALS['TL_LANG']['tl_module']['guests'][1] = 'Hide the module if a member is logged in.';
$GLOBALS['TL_LANG']['tl_module']['cssID'][0] = 'CSS ID/class';
$GLOBALS['TL_LANG']['tl_module']['cssID'][1] = 'Here you can set an ID and one or more classes.';
$GLOBALS['TL_LANG']['tl_module']['space'][0] = 'Space in front and after';
$GLOBALS['TL_LANG']['tl_module']['space'][1] = 'Here you can enter the spacing in front of and after the module in pixel. You should try to avoid inline styles and define the spacing in a style sheet, though.';
$GLOBALS['TL_LANG']['tl_module']['disableCaptcha'][0] = 'Disable the security question';
$GLOBALS['TL_LANG']['tl_module']['disableCaptcha'][1] = 'Here you can disable the security question (not recommended).';
$GLOBALS['TL_LANG']['tl_module']['reg_groups'][0] = 'Member groups';
$GLOBALS['TL_LANG']['tl_module']['reg_groups'][1] = 'Here you can assign the user to one or more groups.';
$GLOBALS['TL_LANG']['tl_module']['reg_allowLogin'][0] = 'Allow login';
$GLOBALS['TL_LANG']['tl_module']['reg_allowLogin'][1] = 'Allow the new user to log into the front end.';
$GLOBALS['TL_LANG']['tl_module']['reg_skipName'][0] = 'Skip username';
$GLOBALS['TL_LANG']['tl_module']['reg_skipName'][1] = 'Do not require the username to request a new password.';
$GLOBALS['TL_LANG']['tl_module']['reg_close'][0] = 'Mode';
$GLOBALS['TL_LANG']['tl_module']['reg_close'][1] = 'Here you can define how to handle the deletion.';
$GLOBALS['TL_LANG']['tl_module']['reg_assignDir'][0] = 'Create a home directory';
$GLOBALS['TL_LANG']['tl_module']['reg_assignDir'][1] = 'Create a home directory from the registered username.';
$GLOBALS['TL_LANG']['tl_module']['reg_homeDir'][0] = 'Home directory path';
$GLOBALS['TL_LANG']['tl_module']['reg_homeDir'][1] = 'Please select the parent folder from the files directory.';
$GLOBALS['TL_LANG']['tl_module']['reg_activate'][0] = 'Send activation e-mail';
$GLOBALS['TL_LANG']['tl_module']['reg_activate'][1] = 'Send an activation e-mail to the registered e-mail address.';
$GLOBALS['TL_LANG']['tl_module']['reg_jumpTo'][0] = 'Confirmation page';
$GLOBALS['TL_LANG']['tl_module']['reg_jumpTo'][1] = 'Please choose the page to which users will be redirected after the request has been completed.';
$GLOBALS['TL_LANG']['tl_module']['reg_text'][0] = 'Activation message';
$GLOBALS['TL_LANG']['tl_module']['reg_text'][1] = 'You can use the wildcards <em>##domain##</em> (domain name), <em>##link##</em> (activation link) and any input field (e.g. <em>##lastname##</em>).';
$GLOBALS['TL_LANG']['tl_module']['reg_password'][0] = 'Password message';
$GLOBALS['TL_LANG']['tl_module']['reg_password'][1] = 'You can use the wildcards <em>##domain##</em> (domain name), <em>##link##</em> (activation link) and any user property (e.g. <em>##lastname##</em>).';
$GLOBALS['TL_LANG']['tl_module']['title_legend'] = 'Title and type';
$GLOBALS['TL_LANG']['tl_module']['nav_legend'] = 'Navigation settings';
$GLOBALS['TL_LANG']['tl_module']['reference_legend'] = 'Reference page';
$GLOBALS['TL_LANG']['tl_module']['redirect_legend'] = 'Redirect settings';
$GLOBALS['TL_LANG']['tl_module']['template_legend'] = 'Template settings';
$GLOBALS['TL_LANG']['tl_module']['image_legend'] = 'Image settings';
$GLOBALS['TL_LANG']['tl_module']['config_legend'] = 'Module configuration';
$GLOBALS['TL_LANG']['tl_module']['include_legend'] = 'Include settings';
$GLOBALS['TL_LANG']['tl_module']['source_legend'] = 'Files and folders';
$GLOBALS['TL_LANG']['tl_module']['interact_legend'] = 'Interactive Flash movie';
$GLOBALS['TL_LANG']['tl_module']['html_legend'] = 'Text/HTML';
$GLOBALS['TL_LANG']['tl_module']['protected_legend'] = 'Access protection';
$GLOBALS['TL_LANG']['tl_module']['expert_legend'] = 'Expert settings';
$GLOBALS['TL_LANG']['tl_module']['email_legend'] = 'E-mail settings';
$GLOBALS['TL_LANG']['tl_module']['account_legend'] = 'Account settings';
$GLOBALS['TL_LANG']['tl_module']['emailText'][0] = 'Your registration on %s';
$GLOBALS['TL_LANG']['tl_module']['emailText'][1] = "Thank you for your registration on ##domain##.\n\nPlease click ##link## to complete your registration and to activate your account. If you did not request an account, please ignore this e-mail.\n";
$GLOBALS['TL_LANG']['tl_module']['passwordText'][0] = 'Your password request on %s';
$GLOBALS['TL_LANG']['tl_module']['passwordText'][1] = "You have requested a new password for ##domain##.\n\nPlease click ##link## to set the new password. If you did not request this e-mail, please contact the website administrator.\n";
$GLOBALS['TL_LANG']['tl_module']['header'] = 'Header';
$GLOBALS['TL_LANG']['tl_module']['left'] = 'Left column';
$GLOBALS['TL_LANG']['tl_module']['main'] = 'Main column';
$GLOBALS['TL_LANG']['tl_module']['right'] = 'Right column';
$GLOBALS['TL_LANG']['tl_module']['footer'] = 'Footer';
$GLOBALS['TL_LANG']['tl_module']['internal'] = 'Internal file';
$GLOBALS['TL_LANG']['tl_module']['external'] = 'External URL';
$GLOBALS['TL_LANG']['tl_module']['close_deactivate'] = 'Deactivate account';
$GLOBALS['TL_LANG']['tl_module']['close_delete'] = 'Irrevocably delete account';
$GLOBALS['TL_LANG']['tl_module']['new'][0] = 'Add module';
$GLOBALS['TL_LANG']['tl_module']['new'][1] = 'Add a module';
$GLOBALS['TL_LANG']['tl_module']['show'][0] = 'Module details';
$GLOBALS['TL_LANG']['tl_module']['show'][1] = 'Show the details of module ID %s';
$GLOBALS['TL_LANG']['tl_module']['edit'][0] = 'Edit module';
$GLOBALS['TL_LANG']['tl_module']['edit'][1] = 'Edit module ID %s';
$GLOBALS['TL_LANG']['tl_module']['cut'][0] = 'Move module';
$GLOBALS['TL_LANG']['tl_module']['cut'][1] = 'Move module ID %s';
$GLOBALS['TL_LANG']['tl_module']['copy'][0] = 'Duplicate module';
$GLOBALS['TL_LANG']['tl_module']['copy'][1] = 'Duplicate module ID %s';
$GLOBALS['TL_LANG']['tl_module']['delete'][0] = 'Delete module';
$GLOBALS['TL_LANG']['tl_module']['delete'][1] = 'Delete module ID %s';
$GLOBALS['TL_LANG']['tl_module']['editheader'][0] = 'Edit theme';
$GLOBALS['TL_LANG']['tl_module']['editheader'][1] = 'Edit the theme settings';
$GLOBALS['TL_LANG']['tl_module']['pasteafter'][0] = 'Paste here';
$GLOBALS['TL_LANG']['tl_module']['pasteafter'][1] = 'Paste after module ID %s';

// system/modules/calendar/languages/en/tl_module.xlf
$GLOBALS['TL_LANG']['tl_module']['cal_calendar'][0] = 'Calendars';
$GLOBALS['TL_LANG']['tl_module']['cal_calendar'][1] = 'Please select one or more calendars.';
$GLOBALS['TL_LANG']['tl_module']['cal_noSpan'][0] = 'Shortened view';
$GLOBALS['TL_LANG']['tl_module']['cal_noSpan'][1] = 'Show events only once even if they span multiple days.';
$GLOBALS['TL_LANG']['tl_module']['cal_startDay'][0] = 'Week start day';
$GLOBALS['TL_LANG']['tl_module']['cal_startDay'][1] = 'Here you can choose the week start day.';
$GLOBALS['TL_LANG']['tl_module']['cal_format'][0] = 'Event list format';
$GLOBALS['TL_LANG']['tl_module']['cal_format'][1] = 'Here you can choose the event list format.';
$GLOBALS['TL_LANG']['tl_module']['cal_ignoreDynamic'][0] = 'Ignore URL parameters';
$GLOBALS['TL_LANG']['tl_module']['cal_ignoreDynamic'][1] = 'Do not switch the time period based on the date/month/year URL parameters.';
$GLOBALS['TL_LANG']['tl_module']['cal_order'][0] = 'Sort order';
$GLOBALS['TL_LANG']['tl_module']['cal_order'][1] = 'Here you can choose the sort order.';
$GLOBALS['TL_LANG']['tl_module']['cal_readerModule'][0] = 'Event reader module';
$GLOBALS['TL_LANG']['tl_module']['cal_readerModule'][1] = 'Automatically switch to the event reader if an event has been selected.';
$GLOBALS['TL_LANG']['tl_module']['cal_limit'][0] = 'Number of events';
$GLOBALS['TL_LANG']['tl_module']['cal_limit'][1] = 'Here you can limit the number of events. Enter 0 to show all.';
$GLOBALS['TL_LANG']['tl_module']['cal_template'][0] = 'Event template';
$GLOBALS['TL_LANG']['tl_module']['cal_template'][1] = 'Here you can select the event template.';
$GLOBALS['TL_LANG']['tl_module']['cal_ctemplate'][0] = 'Calendar template';
$GLOBALS['TL_LANG']['tl_module']['cal_ctemplate'][1] = 'Here you can select the calendar template.';
$GLOBALS['TL_LANG']['tl_module']['cal_showQuantity'][0] = 'Show number of events';
$GLOBALS['TL_LANG']['tl_module']['cal_showQuantity'][1] = 'Show the number of events of each month in the menu.';
$GLOBALS['TL_LANG']['tl_module']['cal_list'] = 'Event list';
$GLOBALS['TL_LANG']['tl_module']['cal_day'] = 'Day';
$GLOBALS['TL_LANG']['tl_module']['cal_month'] = 'Month';
$GLOBALS['TL_LANG']['tl_module']['cal_year'] = 'Year';
$GLOBALS['TL_LANG']['tl_module']['cal_all'] = 'All events';
$GLOBALS['TL_LANG']['tl_module']['cal_upcoming'] = 'Upcoming events';
$GLOBALS['TL_LANG']['tl_module']['next_7'] = '+ 1 week';
$GLOBALS['TL_LANG']['tl_module']['next_14'] = '+ 2 weeks';
$GLOBALS['TL_LANG']['tl_module']['next_30'] = '+ 1 month';
$GLOBALS['TL_LANG']['tl_module']['next_90'] = '+ 3 months';
$GLOBALS['TL_LANG']['tl_module']['next_180'] = '+ 6 months';
$GLOBALS['TL_LANG']['tl_module']['next_365'] = '+ 1 year';
$GLOBALS['TL_LANG']['tl_module']['next_two'] = '+ 2 years';
$GLOBALS['TL_LANG']['tl_module']['next_cur_month'] = 'of the current month';
$GLOBALS['TL_LANG']['tl_module']['next_cur_year'] = 'of the current year';
$GLOBALS['TL_LANG']['tl_module']['next_next_month'] = 'of the next month';
$GLOBALS['TL_LANG']['tl_module']['next_next_year'] = 'of the next year';
$GLOBALS['TL_LANG']['tl_module']['next_all'] = 'All upcoming events';
$GLOBALS['TL_LANG']['tl_module']['cal_past'] = 'Past events';
$GLOBALS['TL_LANG']['tl_module']['past_7'] = '- 1 week';
$GLOBALS['TL_LANG']['tl_module']['past_14'] = '- 2 weeks';
$GLOBALS['TL_LANG']['tl_module']['past_30'] = '- 1 month';
$GLOBALS['TL_LANG']['tl_module']['past_90'] = '- 3 months';
$GLOBALS['TL_LANG']['tl_module']['past_180'] = '- 6 months';
$GLOBALS['TL_LANG']['tl_module']['past_365'] = '- 1 year';
$GLOBALS['TL_LANG']['tl_module']['past_two'] = '- 2 years';
$GLOBALS['TL_LANG']['tl_module']['past_cur_month'] = 'of the current month';
$GLOBALS['TL_LANG']['tl_module']['past_cur_year'] = 'of the current year';
$GLOBALS['TL_LANG']['tl_module']['past_prev_month'] = 'of the previous month';
$GLOBALS['TL_LANG']['tl_module']['past_prev_year'] = 'of the previous year';
$GLOBALS['TL_LANG']['tl_module']['past_all'] = 'All past events';

// system/modules/comments/languages/en/tl_module.xlf
$GLOBALS['TL_LANG']['tl_module']['comment_legend'] = 'Comment settings';

// system/modules/faq/languages/en/tl_module.xlf
$GLOBALS['TL_LANG']['tl_module']['faq_categories'][0] = 'FAQ categories';
$GLOBALS['TL_LANG']['tl_module']['faq_categories'][1] = 'Please select one or more FAQ categories.';
$GLOBALS['TL_LANG']['tl_module']['faq_readerModule'][0] = 'FAQ reader module';
$GLOBALS['TL_LANG']['tl_module']['faq_readerModule'][1] = 'Automatically switch to the FAQ reader if an item has been selected.';

// system/modules/listing/languages/en/tl_module.xlf
$GLOBALS['TL_LANG']['tl_module']['list_table'][0] = 'Table';
$GLOBALS['TL_LANG']['tl_module']['list_table'][1] = 'Please choose the source table.';
$GLOBALS['TL_LANG']['tl_module']['list_fields'][0] = 'Fields';
$GLOBALS['TL_LANG']['tl_module']['list_fields'][1] = 'Please enter a comma separated list of the fields you want to list.';
$GLOBALS['TL_LANG']['tl_module']['list_where'][0] = 'Condition';
$GLOBALS['TL_LANG']['tl_module']['list_where'][1] = 'Here you can enter a condition to filter the results (e.g. <em>published=1</em> or <em>type!="admin"</em>).';
$GLOBALS['TL_LANG']['tl_module']['list_search'][0] = 'Searchable fields';
$GLOBALS['TL_LANG']['tl_module']['list_search'][1] = 'Here you can enter a comma seperated list of fields that you want to be searchable.';
$GLOBALS['TL_LANG']['tl_module']['list_sort'][0] = 'Order by';
$GLOBALS['TL_LANG']['tl_module']['list_sort'][1] = 'Here you can enter a comma seperated list of fields to sort the results by.';
$GLOBALS['TL_LANG']['tl_module']['list_info'][0] = 'Details page fields';
$GLOBALS['TL_LANG']['tl_module']['list_info'][1] = 'Enter a comma separated list of the fields you want to show on the details page. Leave blank to disable the feature.';
$GLOBALS['TL_LANG']['tl_module']['list_info_where'][0] = 'Details page condition';
$GLOBALS['TL_LANG']['tl_module']['list_info_where'][1] = 'Here you can enter a condition to filter the results (e.g. <em>published=1</em> or <em>type!="admin"</em>).';
$GLOBALS['TL_LANG']['tl_module']['list_layout'][0] = 'List template';
$GLOBALS['TL_LANG']['tl_module']['list_layout'][1] = 'Here you can select the list template.';
$GLOBALS['TL_LANG']['tl_module']['list_info_layout'][0] = 'Details page template';
$GLOBALS['TL_LANG']['tl_module']['list_info_layout'][1] = 'Here you can select the details page template.';


/**
 * TYPOlight webCMS
 * Copyright (C) 2005 Leo Feyer
 *
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation, either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program. If not, please visit the Free
 * Software Foundation website at http://www.gnu.org/licenses/.
 *
 * PHP version 5
 * @copyright  Helmut Schottmüller 2008
 * @author     Helmut Schottmüller <helmut.schottmueller@aurealis.de>
 * @package    literature
 * @license    LGPL
 * @filesource
 */

$GLOBALS['TL_LANG']['tl_module']['lit_template']      = array('Reference style', 'Please choose a layout for the literature output. You can add custom <em>litref_</em> layouts to folder <em>templates</em>.');
$GLOBALS['TL_LANG']['tl_module']['lit_categories'] = array('Categories', 'Please select one ore more categories to build the literature list.');
$GLOBALS['TL_LANG']['tl_module']['lit_listtitle'] = array('List title', 'Please enter a list title for the literature list.');
$GLOBALS['TL_LANG']['tl_module']['lit_showsort'] = array('Sort options', 'Choose this option to sort the literature list.');
$GLOBALS['TL_LANG']['tl_module']['lit_sort'] = array('Sort by', 'Please select the sorting colum for the literature list.');
$GLOBALS['TL_LANG']['tl_module']['lit_sort']['title'] = array('Sort by title', 'Choose this option to sort the literature list by title.');
$GLOBALS['TL_LANG']['tl_module']['lit_sort']['released'] = array('Sort by date', 'Choose this option to sort the literature list by release date.');
$GLOBALS['TL_LANG']['tl_module']['lit_sort']['author'] = array('Sort by author', 'Choose this option to sort the literature list by author.');
$GLOBALS['TL_LANG']['tl_module']['lit_sortorder'] = array('Sort order', 'Please select the sort order of the literature list.');
$GLOBALS['TL_LANG']['tl_module']['lit_sortorder']['asc'] = array('Ascending', 'Choose this option to use ascending sort order of the selected sorting colum.');
$GLOBALS['TL_LANG']['tl_module']['lit_sortorder']['desc'] = array('Descending', 'Choose this option to use descending sort order of the selected sorting colum.');
$GLOBALS['TL_LANG']['tl_module']['lit_tags'] = array('Tags', 'Please enter one or more comma separated tags to show only literature references which are tagged with one of these tags.');
$GLOBALS['TL_LANG']['tl_module']['pagetype']['literature']      = 'Literature list';
$GLOBALS['TL_LANG']['tl_module']['litsort_legend'] = 'Sort options';
$GLOBALS['TL_LANG']['tl_module']['literature_legend'] = 'Literature list';


/**
 * Contao Open Source CMS
 * Copyright (C) 2005-2011 Leo Feyer
 *
 * Formerly known as TYPOlight Open Source CMS.
 *
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation, either
 * version 3 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program. If not, please visit the Free
 * Software Foundation website at <http://www.gnu.org/licenses/>.
 *
 * PHP version 5
 * @copyright  Leo Feyer 2005-2011
 * @author     Leo Feyer <http://www.contao.org>
 * @package    Memberlist
 * @license    LGPL
 * @filesource
 */


/**
 * Fields
 */
$GLOBALS['TL_LANG']['tl_module']['ml_groups'] = array('Groups', 'These groups will be listed in the memberlist.');
$GLOBALS['TL_LANG']['tl_module']['ml_fields'] = array('Fields', 'These fields will be visible (subject to individual privacy settings).');

// system/modules/news/languages/en/tl_module.xlf
$GLOBALS['TL_LANG']['tl_module']['news_archives'][0] = 'News archives';
$GLOBALS['TL_LANG']['tl_module']['news_archives'][1] = 'Please select one or more news archives.';
$GLOBALS['TL_LANG']['tl_module']['news_featured'][0] = 'Featured items';
$GLOBALS['TL_LANG']['tl_module']['news_featured'][1] = 'Here you can choose how featured items are handled.';
$GLOBALS['TL_LANG']['tl_module']['news_jumpToCurrent'][0] = 'No period selected';
$GLOBALS['TL_LANG']['tl_module']['news_jumpToCurrent'][1] = 'Here you can define what to display if no period is selected.';
$GLOBALS['TL_LANG']['tl_module']['news_readerModule'][0] = 'News reader module';
$GLOBALS['TL_LANG']['tl_module']['news_readerModule'][1] = 'Automatically switch to the news reader if an item has been selected.';
$GLOBALS['TL_LANG']['tl_module']['news_metaFields'][0] = 'Meta fields';
$GLOBALS['TL_LANG']['tl_module']['news_metaFields'][1] = 'Here you can select the meta fields.';
$GLOBALS['TL_LANG']['tl_module']['news_template'][0] = 'News template';
$GLOBALS['TL_LANG']['tl_module']['news_template'][1] = 'Here you can select the news template.';
$GLOBALS['TL_LANG']['tl_module']['news_format'][0] = 'Archive format';
$GLOBALS['TL_LANG']['tl_module']['news_format'][1] = 'Here you can choose the news archive format.';
$GLOBALS['TL_LANG']['tl_module']['news_startDay'][0] = 'Week start day';
$GLOBALS['TL_LANG']['tl_module']['news_startDay'][1] = 'Here you can choose the week start day.';
$GLOBALS['TL_LANG']['tl_module']['news_order'][0] = 'Sort order';
$GLOBALS['TL_LANG']['tl_module']['news_order'][1] = 'Here you can choose the sort order.';
$GLOBALS['TL_LANG']['tl_module']['news_showQuantity'][0] = 'Show number of items';
$GLOBALS['TL_LANG']['tl_module']['news_showQuantity'][1] = 'Show the number of news items of each month.';
$GLOBALS['TL_LANG']['tl_module']['news_day'] = 'Day';
$GLOBALS['TL_LANG']['tl_module']['news_month'] = 'Month';
$GLOBALS['TL_LANG']['tl_module']['news_year'] = 'Year';
$GLOBALS['TL_LANG']['tl_module']['hide_module'] = 'Hide the module';
$GLOBALS['TL_LANG']['tl_module']['show_current'] = 'Jump to the current period';
$GLOBALS['TL_LANG']['tl_module']['all_items'] = 'Show all news items';
$GLOBALS['TL_LANG']['tl_module']['featured'] = 'Show featured news items only';
$GLOBALS['TL_LANG']['tl_module']['unfeatured'] = 'Skip featured news items';

// system/modules/newsletter/languages/en/tl_module.xlf
$GLOBALS['TL_LANG']['tl_module']['newsletters'][0] = 'Subscribable newsletters';
$GLOBALS['TL_LANG']['tl_module']['newsletters'][1] = 'Show these channels in the front end form.';
$GLOBALS['TL_LANG']['tl_module']['nl_channels'][0] = 'Channels';
$GLOBALS['TL_LANG']['tl_module']['nl_channels'][1] = 'Please select one or more channels.';
$GLOBALS['TL_LANG']['tl_module']['nl_hideChannels'][0] = 'Hide channel menu';
$GLOBALS['TL_LANG']['tl_module']['nl_hideChannels'][1] = 'Do not show the channel selection menu.';
$GLOBALS['TL_LANG']['tl_module']['nl_subscribe'][0] = 'Subscription message';
$GLOBALS['TL_LANG']['tl_module']['nl_subscribe'][1] = 'You can use the wildcards <em>##channels##</em> (channel names), <em>##domain##</em> (domain name) and <em>##link##</em> (activation link).';
$GLOBALS['TL_LANG']['tl_module']['nl_unsubscribe'][0] = 'Unsubscription message';
$GLOBALS['TL_LANG']['tl_module']['nl_unsubscribe'][1] = 'You can use the wildcards <em>##channels##</em> (channel names) and <em>##domain##</em> (domain name).';
$GLOBALS['TL_LANG']['tl_module']['nl_template'][0] = 'Newsletter template';
$GLOBALS['TL_LANG']['tl_module']['nl_template'][1] = 'Here you can select the newsletter template.';
$GLOBALS['TL_LANG']['tl_module']['text_subscribe'][0] = 'Your subscription on %s';
$GLOBALS['TL_LANG']['tl_module']['text_subscribe'][1] = "You have subscribed to the following channels on ##domain##:\n\n##channels##\n\nPlease click ##link## to activate your subscription. If you did not subscribe yourself, please ignore this e-mail.\n";
$GLOBALS['TL_LANG']['tl_module']['text_unsubscribe'][0] = 'Your subscription on %s';
$GLOBALS['TL_LANG']['tl_module']['text_unsubscribe'][1] = "You have unsubscribed from the following channels on ##domain##:\n\n##channels##\n";


/**
 * Contao Open Source CMS
 * Copyright (C) 2005-2011 Leo Feyer
 *
 * Formerly known as TYPOlight Open Source CMS.
 *
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation, either
 * version 3 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program. If not, please visit the Free
 * Software Foundation website at <http://www.gnu.org/licenses/>.
 *
 * PHP version 5
 * @copyright  cgo IT, 2013
 * @author     Carsten Götzinger (info@cgo-it.de)
 * @package    rateit
 * @license    GNU/LGPL
 * @filesource
 */

/**
 * legends
 */
$GLOBALS['TL_LANG']['tl_module']['rateit_legend'] = 'Rate It-Settings';

/**
 * fields
 */
$GLOBALS['TL_LANG']['tl_module']['rateit_title']    = array('Rating title', 'Rating title (shown in backend).');
$GLOBALS['TL_LANG']['tl_module']['rateit_active']   = array('Active', 'Active means that the review is visible to the front-end users.');
$GLOBALS['TL_LANG']['tl_module']['rateit_types']    = array('Types', 'Select the types for which you would like the best ratings to be displayed.');
$GLOBALS['TL_LANG']['tl_module']['rateit_count']    = array('Max. count', 'Max. count of displayed values.');
$GLOBALS['TL_LANG']['tl_module']['rateit_toptype']  = array('List type', 'The x best voted entries oder the x most voted entries.');
$GLOBALS['TL_LANG']['tl_module']['rateit_template'] = array('Template', 'Here you can select the template for the article\'s rating.');

$GLOBALS['TL_LANG']['tl_module']['rateit_types']['page']    = 'Page';
$GLOBALS['TL_LANG']['tl_module']['rateit_types']['article'] = 'Article';
$GLOBALS['TL_LANG']['tl_module']['rateit_types']['ce']      = 'Content Element';
$GLOBALS['TL_LANG']['tl_module']['rateit_types']['module']  = 'Module';
$GLOBALS['TL_LANG']['tl_module']['rateit_types']['news']    = 'News';
$GLOBALS['TL_LANG']['tl_module']['rateit_types']['faq']     = 'FAQ';
$GLOBALS['TL_LANG']['tl_module']['rateit_types']['galpic']  = 'Gallery Picture';

$GLOBALS['TL_LANG']['tl_module']['rateit_toptype']['best']  = 'Best votes';
$GLOBALS['TL_LANG']['tl_module']['rateit_toptype']['most']  = 'Most votes';


/**
 * TYPOlight webCMS
 * Copyright (C) 2005 Leo Feyer
 *
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation, either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program. If not, please visit the Free
 * Software Foundation website at http://www.gnu.org/licenses/.
 *
 * PHP version 5
 * @copyright  Helmut Schottmüller 2008-2010
 * @author     Helmut Schottmüller <contao@aurealis.de>
 * @package    tags
 * @license    LGPL
 * @filesource
 */


/**
 * Fields
 */
$GLOBALS['TL_LANG']['tl_module']['tag_jumpTo']          = array('Jump to page', 'This setting defines to which page a user will be redirected on clicking a tag link.');
$GLOBALS['TL_LANG']['tl_module']['tag_forTable']        = array('Tag tables', 'Please select the tables which are used to show the tag cloud. This selection is valid only if you use the predefined <em>tl_tag</em> table to store the tags.');
$GLOBALS['TL_LANG']['tl_module']['tag_tagtable']        = array('Tag source table', 'Please enter the name of the source table in which the tags can be found. This field defaults to the predefined table <em>tl_tag</em>.');
$GLOBALS['TL_LANG']['tl_module']['tag_tagfield']        = array('Tag table field', 'Please enter the name of the table field which holds the tags. This field defaults to the predefined field name <em>tag</em>.');
$GLOBALS['TL_LANG']['tl_module']['tag_filter']          = array('Tag filter', 'Please enter a comma separated list of tags to filter the output of the module.');
$GLOBALS['TL_LANG']['tl_module']['tag_maxtags']         = array('Maximum number of tags', 'Please enter the maximum number of tags in the tag cloud. If the tag cloud contains more tags than the maximum number of tags, the tags with the smallest number hits will be removed from the cloud. If you don\'t enter a value or the value is 0, all tags will be shown.');
$GLOBALS['TL_LANG']['tl_module']['tag_buckets']         = array('Number of tag sizes', 'Please enter the number of tag sizes in the frontend. Every group of tags gets its own tag size in the frontend. The tag sizes will be give as CSS selectors size1, size2, size3 ... size<em>n</em>.');
$GLOBALS['TL_LANG']['tl_module']['tag_named_class']     = array('Use tag classname', 'Adds an additional CSS class class for every tag which contains the tag name. Use this extra class name for additional styling of tags via CSS. Spaces in the tag names will be replaced with underscores in the CSS class names.');
$GLOBALS['TL_LANG']['tl_module']['tag_on_page_class']   = array('Tag exists on page', 'Adds an additional CSS class (\'here\') for every tag that has been assigned to the actual page.');
$GLOBALS['TL_LANG']['tl_module']['tag_topten']          = array('Top 10 Tags', 'Show the Top 10 Tags above the tag cloud.');
$GLOBALS['TL_LANG']['tl_module']['tag_topten_expanded'] = array('Expand Top 10 Tags', 'Expand the Top 10 Tags tag cloud. All tags in this cloud are visible.');
$GLOBALS['TL_LANG']['tl_module']['tag_all_expanded']    = array('Expand All Tags', 'Expand the \'All Tags\' tag cloud. All tags in this cloud are visible.');
$GLOBALS['TL_LANG']['tl_module']['tag_related']         = array('Show related tags', 'Select this option to show all related tags of a previously selected tag.');
$GLOBALS['TL_LANG']['tl_module']['news_showtags']       = array('Show news tags', 'Select this option to show all assigned tags below each news entry. This only works if you use a tag enabled news template, e.g. news_full_tags');
$GLOBALS['TL_LANG']['tl_module']['tag_ignore']          = array('Ignore tags', 'Force this module to ignore tag related actions (e.g. only show news entries of a given tag)');
$GLOBALS['TL_LANG']['tl_module']['keep_url_params']     = array('Keep URL parameters', 'Keep Contao specific URL parameters (e.g. date parameters of news archives) in the tag links');
$GLOBALS['TL_LANG']['tl_module']['objecttype']          = array('Object type', 'Please select the type of object that should be shown in this list.');
$GLOBALS['TL_LANG']['tl_module']['tagsource']           = array('Tag source', 'Please select the table which is used to build the tag list in this module.');
$GLOBALS['TL_LANG']['tl_module']['pagesource']          = array('Pages', 'Please select the pages that are used to build the object list. If you select a page which contains subpages, all subpages will be used too.');
$GLOBALS['TL_LANG']['tl_module']['articlelist_template'] = array('Articlelist template', 'Here you can select the articlelist template.');
$GLOBALS['TL_LANG']['tl_module']['cloud_template']      = array('Tag cloud template', 'Here you can select the tag cloud template.');
$GLOBALS['TL_LANG']['tl_module']['scope_template']      = array('Tag scope template', 'Here you can select the tag scope template.');
$GLOBALS['TL_LANG']['tl_module']['clear_text']          = array('Tag scope title', 'Please enter a title for the tag scope. The title is a hyperlink that clears the tag scope and removes all selected tags.');
$GLOBALS['TL_LANG']['tl_module']['show_empty_scope']    = array('Show empty scope', 'Show the tag scope even if there are no active tags.');
$GLOBALS['TL_LANG']['tl_module']['tag_show_reset']      = array('Show clear option', 'Show a hyperlink to clear all selected tags.');
$GLOBALS['TL_LANG']['tl_module']['hide_on_empty']       = array('Filtered output only', 'The global articlelist always expects one or more tags to produce a filtered output. Without a tag filter, an empty list is shown.');
$GLOBALS['TL_LANG']['tl_module']['tag_alltags']         = 'All Tags';
$GLOBALS['TL_LANG']['tl_module']['tag_relatedtags']     = 'Related Tags';
$GLOBALS['TL_LANG']['tl_module']['tl_content']          = "Content elements";
$GLOBALS['TL_LANG']['tl_module']['tl_article']          = "Articles";
$GLOBALS['TL_LANG']['tl_module']['tl_news']             = "News articles";
$GLOBALS['TL_LANG']['tl_module']['tag_clear_tags']      = "Clear selected tags";
$GLOBALS['TL_LANG']['tl_module']['tl_calendar_events']  = "Events";
$GLOBALS['TL_LANG']['tl_module']['tl_page']             = "Pages";
$GLOBALS['TL_LANG']['tl_module']['tags']                = "Tags";

/**
 * Legends
 */
$GLOBALS['TL_LANG']['tl_module']['showtags_legend']         = 'Tags settings';
$GLOBALS['TL_LANG']['tl_module']['tagscope_legend']         = 'Tag scope settings';
$GLOBALS['TL_LANG']['tl_module']['size_legend']         = 'Number and size settings';
$GLOBALS['TL_LANG']['tl_module']['tagextension_legend'] = 'Additional tag lists';
$GLOBALS['TL_LANG']['tl_module']['datasource_legend'] = 'Datasource settings';
$GLOBALS['TL_LANG']['tl_module']['object_selection_legend'] = "Object types";
