<?php
/**
 * Contao Open Source CMS
 * Copyright (C) 2005-2010 Leo Feyer
 *
 * Formerly known as TYPOlight Open Source CMS.
 *
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation, either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program. If not, please visit the Free
 * Software Foundation website at <http://www.gnu.org/licenses/>.
 *
 * PHP version 5
 * @copyright  2010 by e@sy Solutions IT <http://www.easySolutionsIT.de/>
 * @author     Patrick Froch <patrick.froch@easySolutionsIT.de/>
 * @package    Language
 * @license    LGPL
 * @filesource
 */

/**
 * Backend modules
 */
$GLOBALS['BE_MOD']['accounts']['user']['reset']         = array('resetPass', 'run');
$GLOBALS['BE_MOD']['accounts']['user']['resetAll']      = array('resetPass', 'runAll');
$GLOBALS['BE_MOD']['accounts']['user']['stylesheet']    = 'system/modules/es_resetpassword/html/style.css';

$GLOBALS['BE_MOD']['accounts']['member']['reset']       = array('resetPass', 'run');
$GLOBALS['BE_MOD']['accounts']['member']['resetAll']    = array('resetPass', 'runAll');
$GLOBALS['BE_MOD']['accounts']['member']['stylesheet']  = 'system/modules/es_resetpassword/html/style.css';


/**
 * Hooks
 */
$GLOBALS['TL_HOOKS']['replaceInsertTags'][]             = array('resetPass', 'myReplaceInsertTags');


/**
 * resetPassword-Settings
 */
$GLOBALS['es_resetPassword']['settings']['usePassList']             = true;
$GLOBALS['es_resetPassword']['settings']['timeForFeedback']         = 300;
$GLOBALS['es_resetPassword']['settings']['rp_prefix']               = '{{database::id}}';
$GLOBALS['es_resetPassword']['settings']['rp_postfix']              = '{{custom::date.y}}';
$GLOBALS['es_resetPassword']['settings']['rp_charclasses']          = array('upper', 'lower', 'digit');
$GLOBALS['es_resetPassword']['settings']['rp_excludechars']         = 'i I l 1 / o O 0';
$GLOBALS['es_resetPassword']['settings']['rp_includespecialchars']  = '§$#';
$GLOBALS['es_resetPassword']['settings']['rp_charcount']            = '3';
$GLOBALS['es_resetPassword']['settings']['rp_peoplefilter']         = array('active');
$GLOBALS['es_resetPassword']['settings']['rp_mailsubject']          = 'Es wurde ein neues Passwort für die Webseite {{env:host}} erstellt';
$GLOBALS['es_resetPassword']['settings']['rp_mailtext']             = "Für die Webseite {{env:host}} wurde ein neues Passwort für Sie erstellt.<br><br>\n\nSie ereichen das Loginformular unter: {{custom::loginlink}}<br>\nIhr Benutzername lautet: {{custom::username}}<br>\nIhr neues Passwort lautet: {{custom::password}}<br>\n<br>\nViele Grüße,<br>\nIhr Administrator";

/**
 * Test-Settings
 */
$GLOBALS['es_resetPassword']['settings']['runTests']                = false;
$GLOBALS['es_resetPassword']['settings']['testscount']              = 1000;
?>