<?php if (!defined('TL_ROOT')) die('You can not access this file directly!');

/**
 * Contao Open Source CMS
 * 
 * Copyright (C) 2005-2012 Leo Feyer
 * 
 * @package   Registration 
 * @author    Daniel Ritter 
 * @copyright Daniel Ritter 2012 
 * @website	  http://www.designr.ch
 * @license   http://www.designr.ch/lizenzen#absolutely-free 
 */


/**
 * Class NotifyAdmin 
 *
 * @author     Daniel Ritter 
 * @copyright  Daniel Ritter 2012 
 */
class NotifyAdmin extends Frontend
{

	/**
	 * Notifiy admin
	 * @param integer
	 * @param array
	 * @param object 
	 */
	public function informAdmin($intId, $arrData, $objModule)
	{
		// Inform admin 
		if ($objModule->reg_notifyAdmin)
		{
			$this->sendAdminNotification($intId, $arrData);
		}
	}


	/**
	 * Send an admin notification e-mail
	 * @param integer
	 * @param array
	 */
	protected function sendAdminNotification($intId, $arrData)
	{
		$objEmail = new Email();

		$objEmail->from = $GLOBALS['TL_ADMIN_EMAIL'];
		$objEmail->fromName = $GLOBALS['TL_ADMIN_NAME'];
		$objEmail->subject = sprintf($GLOBALS['TL_LANG']['MSC']['adminSubject'], $this->Environment->host);

		$strData = "\n\n";

		// Add user details
		foreach ($arrData as $k=>$v)
		{
			if ($k == 'password' || $k == 'tstamp' || $k == 'activation')
			{
				continue;
			}

			$v = deserialize($v);

			if ($k == 'dateOfBirth' && strlen($v))
			{
				$v = $this->parseDate($GLOBALS['TL_CONFIG']['dateFormat'], $v);
			}

			$strData .= $GLOBALS['TL_LANG']['tl_member'][$k][0] . ': ' . (is_array($v) ? implode(', ', $v) : $v) . "\n";
		}

		$objEmail->text = sprintf($GLOBALS['TL_LANG']['MSC']['notifyAdminText'], $intId, $strData . "\n") . "\n";
		$objEmail->sendTo($GLOBALS['TL_ADMIN_EMAIL']);

		$this->log('An admin notification e-mail has been sent', 'NotifyAdmin sendAdminNotification()', TL_ACCESS);
	}
}

?>